# 问答

## 容器是什么？
每一次运输，货主与承运方都会担心因货物类型的不同而导致损失，比如几个铁桶错误地压在了一堆香蕉上。另一方面，运输过程中需要使用不同的交通工具也让整个过程痛苦不堪：货物先装上车运到码头，卸货，然后装上船，到岸后又卸下船，再装上火车，到达目的地，最后卸货。一半以上的时间花费在装、卸货上，而且搬上搬下还容易损坏货物。

容器相当于集装箱

## 为什么需要容器？
容器使软件具备了超强的可移植能力。

#### 容器的优势
对于开发人员 - Build Once, Run Anywhere
容器意味着环境隔离和可重复性。开发人员只需为应用创建一次运行环境，然后打包成容器便可在其他机器上运行。
对于运维人员 - Configure Once, Run Anything
只需要配置好标准的 runtime 环境，服务器就可以运行任何容器。

##  Docker和虚拟机有什么区别？
概念：
Kernel space 是 Linux 内核的运行空间，User space 是用户程序的运行空间。为了安全，它们是隔离的，即使用户的程序崩溃了，内核也不受影响。

区别：
1. 容器内的进程是直接运行于宿主内核的，这点和宿主进程一致，只是容器的 userland 不同，容器的 userland 由容器镜像提供，也就是说镜像提供了 rootfs。
2. Docker 容器只是一个进程而已，只不过利用镜像提供的 rootfs 提供了调用所需的 userland 库支持，使得进程可以在受控环境下运行而已，它并没有虚拟出一个机器出来。
3. 启动容器不需要启动整个操作系统，所以容器部署和启动速度更快，开销更小，也更容易迁移。